# Summary

**CVE-2023-29357** is a critical vulnerability in Microsoft SharePoint Server that is classified as an elevation of privilege (EoP) issue. It allows a remote, unauthenticated attacker to exploit the system by sending a spoofed JSON Web Token (JWT) authentication token. This gives the attacker the same privileges as an authenticated user on the target system.

**CVE-2023-29357** can be chained with other vulnerabilities, such as **CVE-2023-24955**, a remote code execution (RCE) vulnerability, to achieve more damaging attacks like unauthenticated RCE. **CVE-2023-29357** was addressed in Microsoft’s June 2023 Patch Tuesday release. Please note: this is a SharePoint patch, and it will not be automatically installed using Windows Update. SharePoint requires careful patching

Link to memory dump: https://mega.nz/file/uhFB2Iia#LVyGZEHMxBYJrC0ibFBqNcm-rRArjq14v9pd8qB_2EY

```
[Attacker]             [Spoofed JWT]             [SharePoint Server]
    |                         |                           |
    |    [1] Craft JWT        |                           |
    |------------------------>|                           |
    |    with "alg": "none"   |                           |
    |    in header and        |                           |
    |    admin claims in      |                           |
    |    payload              |                           |
    |                         |                           |
    |                         |    [2] Send JWT with      |
    |                         |-------------------------->|
    |                         |    Authorization Header   |
    |                         |    to SharePoint          |
    |                         |    expecting to           |
    |                         |    authenticate as        |
    |                         |    admin                  |
    |                         |                           |
    |                         |    [3] SharePoint         |
    |                         |<--------------------------|
    |                         |    processes JWT and      |
    |                         |    grants admin access    |
    |                         |    due to missing         |
    |                         |    signature validation   |
    |                         |                           |
    |    [4] Attacker gains   |                           |
    |<------------------------|    access with            |
    |    admin-level access   |    admin privileges       |
    |    to SharePoint        |                           |
    |                         |                           |
```

The **`alg: none`** comes from details regarding the **CVE-2023-29357** vulnerability, which involves an issue in Microsoft SharePoint Server where the authentication process could be bypassed. It refers to a type of JWT exploit where the **`alg`** (algorithm) field in the JWT header is manipulated. 

By setting **`alg`** to **`none`**, the attacker indicates that the token is unsigned, which unpatched systems may incorrectly process as a valid token without verifying a signature. This can lead to an attacker impersonate a user or elevate privileges. 

This screenshot shows an **example** of an encoded JWT on the left side and the decoded segments on the right side. We can decode JWT tokens via **https://jwt.io**

![image](https://github.com/DebugPrivilege/InsightEngineering/assets/63166600/ed5fce3c-f472-4a0e-b7e0-bf1950fbfabf)

The decoded parts reveal the JWT's header and payload. The header specifies **`alg: none`**, indicating that the token is unsigned and that the token is intended to bypass signature verification as part of an exploit. The payload contains various claims which is used to authenticate as a privileged user within the SharePoint environment.

The following WinDbg extensions are used during this write-up:

- **MEX:** https://www.microsoft.com/en-us/download/details.aspx?id=53304
- **SOSEX:** https://github.com/DebugPrivilege/Debugging/blob/main/Debugging%20Case%20Studies/Extensions/sosex.dll
- **NETIOEXT:** https://github.com/rodneyviana/netext/releases/tag/2.1.65.5000
- **PDE:** https://onedrive.live.com/?authkey=%21AJeSzeiu8SQ7T4w&cid=DAE128BD454CF957&id=DAE128BD454CF957%2112585&parId=DAE128BD454CF957%217152&o=OneUp


# WinDbg Walk Through - Analysis

Load the Memory Dump in WinDbg:

![image](https://github.com/DebugPrivilege/InsightEngineering/assets/63166600/f9e3a5fe-1546-4429-b2fc-662a0d418e93)


Let's start with the **`!mex.di`** command which stands for dump information. This command retrieves information about the machine from which the memory dump originated. It's especially handy when working with multiple memory dumps, as it helps distinguish the analysis related to each specific dump. This is an improved version of the **`vertarget`** command.

```
0:000> !mex.di
Computer Name: WIN2019
User Name: Administrator
PID: 0xBB0 = 0n2992
Windows 10 Version 17763 MP (8 procs) Free x64
Product: Server, suite: TerminalServer SingleUserTS
Edition build lab: 17763.1.amd64fre.rs5_release.180914-1434
Debug session time: Tue Dec 19 10:14:38.000 2023 (UTC - 8:00)
System Uptime: 0 days 0:03:37.090
Process Uptime: 0 days 0:02:41.000
  Kernel time: 0 days 0:00:07.000
  User time: 0 days 0:00:11.000
```

The **NETEXT** extension enhances the debugging capabilities for applications that use the .NET framework. It provides a wide range of commands that allow us to inspect and manipulate various aspects of .NET applications during debugging sessions.

```
0:000> !netext.help
Commands for C:\Users\Admin\AppData\Local\Dbg\EngineExtensions\netext.dll:
  !help              - Displays information on available extension commands
  !regmatch          - Find and print lines matching the pattern
                       
                       Usage: !regmatch [-case] [-flavor (basic | extended |
                       ecmascript | awk | grep | egrep)] [-not] '<pattern>'
                       '<execute-pattern>' << <command-list>
                       Where:
                       	-case is the switch for case sensitiviness. If present
                       search is case sensitive (default is case insensitive)
                       	-flavor is the flavor of the T1 Regex. See
                       http://msdn.microsoft.com/en-us/library/bb982727.aspx
                       	<pattern> is the regex pattern. See examples here:
                       http://msdn.microsoft.com/en-us/library/ms972966.aspx
                       	Examples:
                       
                       Dump all stack object
                       	!regmatch -run '(^[0-9a-fA-F]+)\s+([0-9a-fA-F]+)\s'
                       "!do $2" << !dso
  !regsearch         - Find and print lines matching the pattern
                       
                       Usage: !regsearch [-case] [-flavor (basic | extended |
                       ecmascript | awk | grep | egrep)] [-not] <pattern>
                       <command-list>
                       Where:
                       	-case is the switch for case sensitiviness. If present
                       search is case sensitive (default is case insensitive)
                       	-flavor is the flavor of the T1 Regex. See
                       http://msdn.microsoft.com/en-us/library/bb982727.aspx
                       	<pattern> is the regex pattern. See examples here:
                       http://msdn.microsoft.com/en-us/library/ms972966.aspx
                       	Examples:
                       
                       Lists only stack objects containing httpcontext
                       	!regseach  httpcontext !dso
  !wapppool          - Display the Application Pool details
  !wclass            - Dump Class Layout. Use '!whelp wclass' for detailed help
  !wclrstack         - Dump current stack trace. Use !whelp wclrstack for more
                       help
  !wconcurrentdict   - Dump ConcurrentDictionary. Use '!whelp wconcurrentdict'
                       for detailed help
  !wconfig           - Dump Config file lines in memory. Use '!whelp wconfig'
                       for detailed help
  !wcookie           - Dump all cookies for all context, a single context or
                       matching a cookie filter criteria. Use '!whelp wcookie'
                       for detailed help
  !wdae              - Dump All Exceptions. Use '!whelp wdae' for detailed help
  !wdict             - Dump Dictionary. Use '!whelp wdict' for detailed help
  !wdo               - Dump object. Use '!whelp wdo' for detailed help
  !wdomain           - Dump Application Domains. Use '!whelp wdomain' for
                       detailed help
  !weval             - Evaluate ad-hoc commands separated by commas. Use
                       '!whelp weval' for detailed help
  !wfrom             - Dump object fields from Address, Stack or GAC. Use
                       '!whelp wfrom' for detailed help
  !wgchandle         - Dump GC Handles. Use '!whelp wgchandle' for detailed
                       help
  !whash             - Dump Hash Table. Use '!whelp whash' for detailed help
  !wheap             - Dump heap objects. Use '!whelp wheap' for detailed help
  !whelp             - Provide hyper-text help
  !whttp             - Dump HttpContext. Use '!whelp whttp' for detailed help
  !widnauls          - Command to list ULS position and tag and can be filtered
                       by message or category
  !windex            - Index and dump heap. Use '!whelp windex' for detailed
                       help
  !wk                - Dump current stack trace in mixed mode (native/managed).
                       Use !whelp wk for more help
  !wkeyvalue         - Dump NameObjectCollection types. Use '!whelp wkeyvalue'
                       for detailed help
  !wmakesource       - It tries to reflect the current frame into source code.
                       Use '!whelp wmakesource' for detailed help
  !wmodule           - Dump all modules in process which can be filtered by
                       name, company, debug mode, etc. Use '!whelp wmodule' for
                       detailed help
  !wopendownloadpage - Check latest version and open download page if there is
                       an update
  !wopensource       - Open the managed source code based on IP. Use '!whelp
                       wopensource' for detailed help
  !wp                - Step-out managed code (like F10 in Visual Studio)
  !wpe               - Dump Exception Object. Use '!whelp wpe' for detailed
                       help
  !wruntime          - Dump Http Runtime information as Active Requests and App
                       Domain Id
  !wselect           - Dump object fields from Address, Stack or GAC. Use
                       '!whelp wselect' for detailed help
  !wservice          - Dump WCF Services. Use '!whelp wservice' for detailed
                       help
  !wsetruntime       - Dump object. Use '!whelp wsetruntime' for detailed help
  !wsocket           - Dump a single socket or a summary of all sockets. Use
                       '!whelp wsocket' for detailed help
  !wsql              - Dump all sql commands, a single sql command or commands
                       matching a cookie filter criteria. Use '!whelp wsql' for
                       detailed help
  !wstack            - Dump stack objects. Use '!whelp wstack' for detailed
                       help
  !wt                - Step-into managed code (like F11 in Visual Studio)
  !wthreads          - Dump Managed Threads. Use '!whelp wthreads' for detailed
                       help
  !wtime             - Show UTC and local time. Use '!whelp wtime' for detailed
                       help
  !wtoken            - Dump all security tokens or matching a token filter
                       criteria. Use '!whelp wtoken' for detailed help
  !wupdate           - Try to open download page in default browser
  !wvar              - Dump Environment Variables. Use '!whelp wvar' for
                       detailed help
  !wver              - Load .NET and display its version
  !wxml              - Dump XML Document or XML Node. Use '!whelp wkeyvalue'
                       for detailed help
!help <cmd> will give more information for a particular command
```

The output from the **`!netext.wapppool`** command provides detailed information about an IIS Application Pool. This specifies the name of the Application Pool. Here we can see that it's associated with a **SharePoint** site.

```
0:000> !netext.wapppool
AppPool Name         : SharePoint - 80
AppPool .NET Version : v4.0
IIS Version          : 10.0.1.17763
Full Command Line    : c:\windows\system32\inetsrv\w3wp.exe -ap "SharePoint - 80" -v "v4.0" -l "webengine4.dll" -a \\.\pipe\iisipm3955e99e-77d7-4c49-89e5-06e58280cb2f -h "C:\inetpub\temp\apppools\SharePoint - 80\SharePoint - 80.config" -w "" -m 0
Process Account      : DC\Administrator
Machine Name         : WIN2019
Domain Name          : DC
```

The output of the **`!netext.wfrom`** command provides information about various HTTP requests being processed. **`!netext.wfrom`** allows us to query and display data from .NET objects in memory. By selecting specific fields and formatting them, it provides a clear overview of key request attributes such as the URL, method, status code, timestamp, and execution thread.

```
0:000> !netext.wfrom -nospace -nofield -type *.HttpContext select $rpad($addr(),10), " ", $if(!_thread, " --", $lpad($thread(_thread.DONT_USE_InternalThread),4)), " ", $tickstodatetime(_utcTimestamp.dateData), " ", $if((_timeoutSet==1),$tickstotimespan(_timeout._ticks), "Not set "), " ", $if(_response._completed || _finishPipelineRequestCalled,"Finished", $tickstotimespan($now()-_utcTimestamp.dateData)), " ", $replace($lpad(_response._statusCode,8), "0n","")," ", $rpad($isnull(_request._httpMethod,"NA"),8), " ", $isnull(_request._url.m_String, _request._filePath._virtualPath)
0000026C6E5A3400  -- 12/19/2023 6:12:37 PM 00:00:00 Finished    200 GET      http://win2019:80/_vti_bin/client.svc/web/currentuser
0000026C6E695940  -- 12/19/2023 6:12:55 PM 00:00:00 Finished    404 GET      http://win2019:80/_vti_bin/DelveApi.ashx/gift_from_starlabs/ghostshell5918.aspx
0000026CEE238468  -- 12/19/2023 6:12:07 PM 00:00:00 Finished    200 GET      http://win2019:80/_vti_bin/client.svc/web/currentuser
0000026CEE51DBC8  -- 12/19/2023 6:12:47 PM 00:00:00 Finished    200 POST     http://win2019:80/_vti_bin/client.svc/ProcessQuery
0000026CEE5664F0  -- 12/19/2023 6:13:08 PM 00:00:00 Finished    200 POST     http://win2019:80/_vti_bin/client.svc/web/GetFolderByServerRelativeUrl('/BusinessDataMetadataCatalog/')/Files/add(url='/BusinessDataMetadataCatalog/BDCMetadata.bdcm',overwrite=true)
```

The two functions in this code snippet are coming from the POC of the exploit itself. The functions that are highlighted are designed to interact with a SharePoint server as part of an exploitation chain. The full code can be found here: https://gist.github.com/testanull/dac6029d306147e6cc8dce9424d09868

![image](https://github.com/DebugPrivilege/InsightEngineering/assets/63166600/acf13f90-552a-412a-a7d7-333e81d4e75f)

The function **`createBDCMpayload()`** initiates a POST request to the SharePoint server targeting the URI **`/_api/web/GetFolderByServerRelativeUrl('/BusinessDataMetadataCatalog/')/Files/add(url='/BusinessDataMetadataCatalog/BDCMetadata.bdcm',overwrite=true)`**. The request includes a specially crafted XML payload. **`execCmd(_entityId, _liIdentity)`** executes a command on the SharePoint server by sending a POST request to **`/_vti_bin/client.svc/ProcessQuery`**.

This command searches the entire memory space for instances of the string **`"http://win2019"`**, the reason that we're doing is to a double check the HTTP requests we're particularly looking for. It checks each occurrence for a specific pattern, and if the pattern is found, it prints a message and displays a memory dump of 10 bytes starting from that address.

```
0:000> .foreach (address { s -[l 8]a 0 L?0x7fffffffffffffff "http://win2019" }) { .if ($spat("${address}", "0000*`*")) { .echo Found "HTTP Request of Interest" at ${address}; !pde.dpx ${address} ${address}+10 } }
Found "HTTP Request of Interest" at 00000269`813f8b58
Start memory scan  : 0x00000269813f8b58
End memory scan    : 0x00000269813f8b68

               rsp : 0x000000e71e91f578 : 0x00007ffc8bdf4513 : KERNELBASE!WaitForSingleObjectEx+0x93
                r8 : 0x000000e71e91f318 : 0x00007ffc8be44d07 : KERNELBASE!PerfSetCounterRefValue+0x47
0x00000269813f8b58 : 0x772f2f3a70747468 :  !da "http://win2019/_api/Web/GetFolderByServerRelativePath(decodedurl='/BusinessDataM..."
0x00000269813f8b60 : 0x5f2f393130326e69 :  !da "in2019/_api/Web/GetFolderByServerRelativePath(decodedurl='/BusinessDataMetadataC..."
0x00000269813f8b68 : 0x2f6265572f697061 :  !da "api/Web/GetFolderByServerRelativePath(decodedurl='/BusinessDataMetadataCatalog')..."

<<< SNIPPET >>>

Found "HTTP Request of Interest" at 00000269`821061a4
Start memory scan  : 0x00000269821061a4
End memory scan    : 0x00000269821061b4

               rsp : 0x000000e71e91f578 : 0x00007ffc8bdf4513 : KERNELBASE!WaitForSingleObjectEx+0x93
                r8 : 0x000000e71e91f318 : 0x00007ffc8be44d07 : KERNELBASE!PerfSetCounterRefValue+0x47
0x00000269821061a4 : 0x772f2f3a70747468 :  !da "http://win2019/_vti_bin/client.svc/ProcessQuery"
0x00000269821061ac : 0x5f2f393130326e69 :  !da "in2019/_vti_bin/client.svc/ProcessQuery"
0x00000269821061b4 : 0x2f6e69625f697476 :  !da "vti_bin/client.svc/ProcessQuery"

<<< SNIPPET >>>
```


The **`!Mex.DisplayObj`** command displays the properties and state of a specific **`System.Web.HttpContext`** object at the memory address **`0x0000026cee51dbc8`**. This command is inspecting the internal state of an ASP.NET HTTP context object and shows various fields that we can inspect further.

```
0:000> !Mex.DisplayObj 0x0000026cee51dbc8
0x0000026cee51dbc8 System.Web.HttpContext
[statics]
  0000  _asyncAppHandler                                          : NULL
  0008  _appInstance                                              : NULL
  0010  _handler                                                  : NULL
  0018  _request                                                  : 0000026cee51dd88 (System.Web.HttpRequest)
  0020  _response                                                 : 0000026cee51df10 (System.Web.HttpResponse)
  0028  _server                                                   : 0000026cee55f278 (System.Web.HttpServerUtility)
  0030  _traceContextStack                                        : NULL
  0038  _topTraceContext                                          : 0000026cee5299c0 (System.Web.TraceContext)
  0040  _items                                                    : NULL
  0048  _errors                                                   : NULL
  0050  _tempError                                                : NULL
  0058  _principalContainer                                       : 0000026cee51e118 (System.Web.RootedObjects)
  0060  _Profile                                                  : NULL
  0068  _wr                                                       : 0000026cee51d778 (System.Web.Hosting.IIS7WorkerRequest)
  0070  _configurationPath                                        : NULL
  0078  _dynamicCulture                                           : 0000026d6de41a88 (System.Globalization.CultureInfo)
  0080  _dynamicUICulture                                         : 0000026d6de41a88 (System.Globalization.CultureInfo)
  0088  _handlerStack                                             : NULL
  0090  _pageInstrumentationService                               : NULL
  0098  _webSocketRequestedProtocols                              : NULL
  00a0  _timeoutCancellationTokenHelper                           : 0000026cee234cc8 (System.Web.Util.CancellationTokenHelper)
  00a8  _timeoutLink                                              : NULL
  00b0  _thread                                                   : NULL
  00b8  _configurationPathData                                    : NULL
  00c0  _filePathData                                             : 0000026d6e034a28 (System.Web.CachedPathData)
  00c8  _sqlDependencyCookie                                      : NULL
  00d0  _sessionStateModule                                       : NULL
  00d8  _templateControl                                          : NULL
  00e0  _notificationContext                                      : NULL
  00e8  IndicateCompletionContext                                 : NULL
  00f0  ThreadInsideIndicateCompletion                            : NULL
  00f8  ThreadContextId                                           : 0000026cee51dd70 (System.Object)
  0100  _syncContext                                              : NULL
  0108  _threadWhichStartedWebSocketTransition                    : NULL
  0110  _webSocketNegotiatedProtocol                              : NULL
  0118  _remapHandler                                             : NULL
  0120  _currentHandler                                           : NULL
  0128  <System.Web.IPrincipalContainer.Principal>k__BackingField : NULL
  0130  _rootedObjects                                            : 0000026cee51e118 (System.Web.RootedObjects)
  0138  _CookielessHelper                                         : 0000026cee51e068 (System.Web.Security.CookielessHelperClass)
  0140  _timeoutStartTimeUtcTicks                                 : 638386063758426065 (System.Int64)
  0148  _timeoutTicks                                             : 21474836470000000 (System.Int64)
  0150  _rootedPtr                                                : 0000000000000000 (System.IntPtr)
  0158  _asyncPreloadModeFlags                                    : None (0) (System.Web.Configuration.AsyncPreloadModeFlags)
  015c  _serverExecuteDepth                                       : 0 (System.Int32)
  0160  _timeoutState                                             : 0 (System.Int32)
  0164  <SessionStateBehavior>k__BackingField                     : Disabled (3) (System.Web.SessionState.SessionStateBehavior)
  0168  _asyncPreloadModeFlagsSet                                 : True (System.Boolean)
  0169  _errorCleared                                             : False (System.Boolean)
  016a  _skipAuthorization                                        : False (System.Boolean)
  016b  _preventPostback                                          : False (System.Boolean)
  016c  _runtimeErrorReported                                     : False (System.Boolean)
  016d  _threadAbortOnTimeout                                     : True (System.Boolean)
  016e  _delayedSessionState                                      : False (System.Boolean)
  016f  _isAppInitialized                                         : True (System.Boolean)
  0170  _isIntegratedPipeline                                     : True (System.Boolean)
  0171  _finishPipelineRequestCalled                              : True (System.Boolean)
  0172  _impersonationEnabled                                     : True (System.Boolean)
  0173  HideRequestResponse                                       : False (System.Boolean)
  0174  InIndicateCompletion                                      : False (System.Boolean)
  0175  _webSocketTransitionState                                 : Inactive (0) (System.Web.WebSocketTransitionState)
  0176  <FirstRequest>k__BackingField                             : False (System.Boolean)
  0177  _requiresSessionStateFromHandler                          : True (System.Boolean)
  0178  _readOnlySessionStateFromHandler                          : False (System.Boolean)
  0179  InAspCompatMode                                           : False (System.Boolean)
  017a  <DisableCustomHttpEncoder>k__BackingField                 : False (System.Boolean)
  017b  _ProfileDelayLoad                                         : False (System.Boolean)
  0180  _utcTimestamp                                             : 0000026cee51dd50 12/19/2023 6:12:47 PM (System.DateTime)
  0188  _requestCompletedQueue                                    : 0000026cee51dd58 (System.Web.Util.SubscriptionQueue<System.Action<System.Web.HttpContext>>)
  0190  _pipelineCompletedQueue                                   : 0000026cee51dd60 (System.Web.Util.SubscriptionQueue<System.IDisposable>)
```

This command output displays the internal state and properties of the **`System.Web.Hosting.IIS7WorkerRequest`** object at memory address **`0x0000026cee51d778`**. This object represents an IIS worker request in an ASP.NET.

```
0:000> !mex.DisplayObj 0x0000026cee51d778
0x0000026cee51d778 System.Web.Hosting.IIS7WorkerRequest
[statics]
  0000  _isInReadEntitySync          : False (System.Boolean)
  0008  _startTime                   : 0000026cee51d788 12/19/2023 6:12:47 PM (System.DateTime)
  0010  _traceId                     : 0000026cee51d790 00000000-0000-0000-0000-000000000000 (System.Guid)
  0020  _headerEncoding              : 0000026d6de4a820 (System.Text.UTF8Encoding)
  0028  _asyncResultBase             : NULL
  0030  _appPath                     : 0000026cee51db30  "/" [1] (System.String)
  0038  _appPathTranslated           : 0000026cee51db50  "C:\inetpub\wwwroot\wss\VirtualDirectorie..." [45] (System.String)
  0040  _path                        : 0000026cee51d980  "/_vti_bin/client.svc/ProcessQuery" [33] (System.String)
  0048  _queryString                 : 0000026aeddf1420  "" [0] (System.String)
  0050  _filePath                    : 0000026cee51d9e0  "/_vti_bin/client.svc" [20] (System.String)
  0058  _pathInfo                    : 0000026cee51da28  "/ProcessQuery" [13] (System.String)
  0060  _pathTranslated              : 0000026cee51da60  "C:\Program Files\Common Files\Microsoft ..." [88] (System.String)
  0068  _httpVerb                    : 0000026cee51d958  "POST" [4] (System.String)
  0070  _unknownRequestHeaders       : 0000026cee526ed8 (System.String[][]) [Length: 2]
  0078  _knownRequestHeaders         : 0000026cee526278 (System.String[]) [Length: 40]
  0080  _cachedResponseBodyBytes     : NULL
  0088  _preloadedContent            : NULL
  0090  _cacheUrl                    : 0000026cee51d8c0  "http://win2019:80/_vti_bin/client.svc/Pr..." [50] (System.String)
  0098  _clientCert                  : NULL
  00a0  _clientCertPublicKey         : NULL
  00a8  _clientCertBinaryIssuer      : NULL
  00b0  _channelBindingToken         : NULL
  00b8  _disposeLockObj              : 0000026cee51d8a8 (System.Object)
  00c0  _clientDisconnectTokenHelper : NULL
  00c8  _allocator                   : 0000026d6e003f78 (System.Web.AllocatorProvider)
  00d0  _context                     : 0000000000000000 (System.IntPtr)
  00d8  _pCookedUrl                  : 0000000000000000 (System.IntPtr)
  00e0  _contentType                 : 1 (System.Int32)
  00e4  _contentTotalLength          : 876 (System.Int32)
  00e8  _cachedResponseBodyLength    : 0 (System.Int32)
  00ec  _preloadedLength             : 0 (System.Int32)
  00f0  _clientCertEncoding          : 0 (System.Int32)
  00f4  _rewriteNotifyDisabled       : False (System.Boolean)
  00f5  _rebaseClientPath            : False (System.Boolean)
  00f6  _requestHeadersAvailable     : True (System.Boolean)
  00f7  _preloadedLengthRead         : True (System.Boolean)
  00f8  _preloadedContentRead        : True (System.Boolean)
  00f9  _traceEnabled                : False (System.Boolean)
  00fa  _connectionClosed            : False (System.Boolean)
  00fb  _disconnected                : False (System.Boolean)
  00fc  _headersSent                 : True (System.Boolean)
  00fd  _trySkipIisCustomErrors      : True (System.Boolean)
  00fe  _clientCertFetched           : False (System.Boolean)
  0100  _traceId                     : 0000026cee51d880 00000000-0000-0000-0000-000000000000 (System.Guid)
  0110  _clientCertValidFrom         : 0000026cee51d890 1/1/0001 12:00:00 AM (System.DateTime)
  0118  _clientCertValidUntil        : 0000026cee51d898 1/1/0001 12:00:00 AM (System.DateTime)
```

The **`_cacheUrl`** field in the **`System.Web.Hosting.IIS7WorkerRequest`** object represents the cached URL of the current HTTP request being processed. In this context, the value **`http://win2019:80/_vti_bin/client.svc/ProcessQuery`** indicates the full URL that was requested.

```
0:000> !mex.DisplayObj 0x0000026cee51d8c0
[raw] 0000026cee51d8c0 "http://win2019:80/_vti_bin/client.svc/ProcessQuery"
```

The **`_knownRequestHeaders`** field in the provided data represents a collection of known HTTP request headers.

```
0:000> !mex.DisplayObj 0x0000026cee526278
[raw] 0000026cee526278 System.String[] Length: 40
[01] 0000026cee5263d0  "keep-alive" [10] (System.String)
[11] 0000026cee526400  "876" [3] (System.String)
[12] 0000026cee526420  "application/x-www-form-urlencoded" [33] (System.String)
[20] 0000026cee526480  "*/*" [3] (System.String)
[22] 0000026cee5264a0  "gzip, deflate" [13] (System.String)
[24] 0000026cee5264d8  "Bearer eyJhbGciOiAibm9uZSJ9.eyJpc3MiOiIw..." [545] (System.String)
[28] 0000026cee526950  "win2019" [7] (System.String)
[39] 0000026cee526978  "python-requests/2.27.1" [22] (System.String)
```

From this information, we can now extract the JWT (JSON Web Token). It starts with "Bearer", which is a common prefix used in the Authorization header where the JWT is provided. 

```
0:000> !mex.DisplayObj 0x0000026cee5264d8
[raw] 0000026cee5264d8 "Bearer eyJhbGciOiAibm9uZSJ9.eyJpc3MiOiIwMDAwMDAwMy0wMDAwLTBmZjEtY2UwMC0wMDAwMDAwMDAwMDAiLCJhdWQiOiIwMDAwMDAwMy0wMDAwLTBmZjEtY2UwMC0wMDAwMDAwMDAwMDBANTYzODc4OTctMGY2MC00NGM4LWIxYjktM2Q2YTAxZTVkNWVhIiwibmJmIjoiMTY3MzQxMDMzNCIsImV4cCI6IjE3MjUwOTM4OTAiLCJuYW1laWQiOiIwMDAwMDAwMy0wMDAwLTBmZjEtY2UwMC0wMDAwMDAwMDAwMDBANTYzODc4OTctMGY2MC00NGM4LWIxYjktM2Q2YTAxZTVkNWVhIiwgInZlciI6Imhhc2hlZHByb29mdG9rZW4iLCJlbmRwb2ludHVybCI6ICJxcWxBSm1UeHBCOUE2N3hTeVprK3RtcnJObVlDbFkvZnFpZzdjZVpOc1NNPSIsImVuZHBvaW50dXJsTGVuZ3RoIjogMSwgImlzbG9vcGJhY2siOiAidHJ1ZSJ9.YWFh"
```

When we are decoding the JWT, we observe that the specified algorithm ("alg") is set to "none," indicating that the token lacks a digital signature. 

![image](https://github.com/DebugPrivilege/InsightEngineering/assets/63166600/1723870b-9bc5-4717-80aa-743133e9ceb8)

The output from the **`!ForEachObject`** command shows a **`System.Diagnostics.ProcessStartInfo`** object in memory that has been configured to launch cmd.exe with the argument /c mspaint.exe. This output suggests that the exploit is leveraging **`System.Diagnostics.ProcessStartInfo`** object to execute arbitrary command.

```
0:000> !ForEachObject -s -x "!do2 @#Obj" System.Diagnostics.ProcessStartInfo
0x0000026a6e5beae0 System.Diagnostics.ProcessStartInfo
  0000  fileName                : 0000026a6e5bea80  "cmd.exe" [7] (System.String)
  0008  arguments               : 0000026a6e5beaa8  "/c mspaint.exe" [14] (System.String)
  0010  directory               : NULL
  0018  verb                    : NULL
  0020  userName                : NULL
  0028  domain                  : NULL
  0030  password                : NULL
  0038  passwordInClearText     : NULL
  0040  standardOutputEncoding  : NULL
  0048  standardErrorEncoding   : NULL
  0050  weakParentProcess       : NULL
  0058  environmentVariables    : NULL
  0060  environment             : NULL
  0068  errorDialogParentHandle : 0000000000000000 (System.IntPtr)
  0070  windowStyle             : Normal (0) (System.Diagnostics.ProcessWindowStyle)
  0074  errorDialog             : False (System.Boolean)
  0075  useShellExecute         : True (System.Boolean)
  0076  loadUserProfile         : False (System.Boolean)
  0077  redirectStandardInput   : False (System.Boolean)
  0078  redirectStandardOutput  : False (System.Boolean)
  0079  redirectStandardError   : False (System.Boolean)
  007a  createNoWindow          : False (System.Boolean)
--------------------------------------------------------------------------------
1 objects found.
```

The **`!wdomain`** command is used to dump information about **`AppDomains`** loaded in the process. An **`AppDomain`** in .NET is an application domain, which is a mechanism used by the .NET Framework to isolate executed applications or components from one another within the same process. It provides information, including its name, base folder, configuration file, and the modules (assemblies) loaded into it.

```
0:000> !netext.wdomain
Address          Domain Name                                                 Modules Base Path & Config
00007ffc8131c2c0 System                                                              
00007ffc8131bcf0 Shared                                                           60 
00000269ec92ef10 DefaultDomain                                                     7 Base Path: c:\windows\system32\inetsrv\ Config: w3wp.exe.config 
00000269ed277340 /LM/W3SVC/292997548/ROOT-1-133474831174272020                   227 Base Path: C:\inetpub\wwwroot\wss\VirtualDirectories\80\ Config: web.config 
0000026981550fa0 XAPwtirA                                                         21 Base Path: C:\inetpub\wwwroot\wss\VirtualDirectories\80\ Config: web.config
```

In this situation, my focus will be on reviewing the **`AppDomain`** that is associated with an ASP.NET application running under IIS. **`/LM/W3SVC`** is the one that we're talking about. **`LM`** stands for "Local Machine," and **`W3SVC`** is the service in IIS responsible for managing HTTP requests.  

```
0:000> !whelp wmodule
Dump modules filtered by type or pattern.

The types are:
- Not from Microsoft
- Managed only
- Compiled in debug mode (managed code only)
 

Syntax:
-------
 
!wmodule [-debug] [-managed] [-noms] [-order] [-fullpath] [-name <partial-name>]
         [-company <partial-name>] [-saveto <folder>] [-domain <domain-address>]


Where:
	-debug Lists only managed modules compiled in debug mode. Optional
	-managed Lists only managed modules. Optional
	-noms Lists modules which are not from Microsoft (it may contain false positives). Optional
	-order The output will be sorted by name. Optional
	-fullpath It includes the full path to the modules. Optional
	-name <partial-name> List only modules matching the pattern (e.g -name Contoso.MyLibrary*). Optional
	-company <partial-name> List only modules from the company in the pattern (e.g -company TailsSpin*). Optional
	-domain <domain-address> List only modules from the domain (e.g -domain 007f23ac090). Optional
	-saveto <folder>When present it will save the selected module to an existing folder (e.g. -saveto c:\my mods\). Optional. Must be at the end.

Note: -saveto <folder> must be the last parameter. Do not use quotes.
```

This command displays a list of non-Microsoft modules (indicated by **`-noms`**) loaded in a specific **`AppDomain`** with their full paths. The **`!mex.grep -v`** excludes the string 'Microsoft Corporation' from the output to reduce the amount of results.

```
0:000> !mex.grep -v 'Microsoft Corporation' !netext.wmodule -noms -fullpath -domain 00000269ed277340
Address                      Module Version Company Name       Debug Mode Type Module Binary
0000026e88570000                    0.0.0.0                           No   CLR C:\Windows\Microsoft.NET\Framework64\v4.0.30319\Temporary ASP.NET Files\root\204afe7a\d38d8771\App_GlobalResources.cvxln2xn.dll
0000026e85df0000                    0.0.0.0                           No   CLR C:\Windows\Microsoft.NET\Framework64\v4.0.30319\Temporary ASP.NET Files\root\204afe7a\d38d8771\App_global.asax.plmagkoz.dll
0000026e85f90000                    0.0.0.0                           No   CLR C:\Windows\Microsoft.NET\Framework64\v4.0.30319\Temporary ASP.NET Files\root\204afe7a\d38d8771\App_Browsers.blaa4mfz.dll
0000026e79a90000                        0.0                           Yes  CLR C:\Windows\Microsoft.Net\assembly\GAC_MSIL\Cil.Core\v4.0_3.0.0.0__71e9bce111e9429c\Cil.Core.dll
00007ffc6fb30000                6.0.8.18111 Newtonsoft                No   CLR C:\Windows\assembly\NativeImages_v4.0.30319_64\Newtonsoft.Json\cf2d4658986b522132737d6a8e9035ef\Newtonsoft.Json.ni.dll
0000026e79d30000                        1.0                           No   CLR C:\Windows\Microsoft.Net\assembly\GAC_MSIL\Owin\v4.0_1.0.0.0__f0ebd12fd5e55cc5\Owin.dll
0000026e8a780000                        0.0                           Yes  CLR C:\inetpub\wwwroot\wss\VirtualDirectories\80\_app_bin\Microsoft.OneDrive.Owin.dll
0000026e8aa90000                        0.0                           Yes  CLR C:\inetpub\wwwroot\wss\VirtualDirectories\80\_app_bin\Microsoft.OneDrive.Infrastructure.dll
0000026e8aaf0000                        0.0                           Yes  CLR C:\inetpub\wwwroot\wss\VirtualDirectories\80\_app_bin\Microsoft.OneDrive.ServiceLocation.dll
0000000000000000                        0.0 NA                        No   CLR {dynamic-assembly}
0000026e8ab70000                        0.0                           Yes  CLR C:\inetpub\wwwroot\wss\VirtualDirectories\80\_app_bin\Microsoft.Vroom.Client.dll
0000026e8abe0000                        0.0                           Yes  CLR C:\inetpub\wwwroot\wss\VirtualDirectories\80\_app_bin\Microsoft.Vroom.dll
0000026e8ab90000                        0.0                           Yes  CLR C:\inetpub\wwwroot\wss\VirtualDirectories\80\_app_bin\Microsoft.Vroom.Models.dll
0000026e8ab00000                        0.0                           Yes  CLR C:\inetpub\wwwroot\wss\VirtualDirectories\80\_app_bin\Microsoft.Vroom.Owin.dll
0000026e8aec0000                        0.0                           Yes  CLR C:\inetpub\wwwroot\wss\VirtualDirectories\80\_app_bin\WinLive.SkyShared.Infrastructure.Streams.dll
0000026e8ae90000                        0.0                           Yes  CLR C:\inetpub\wwwroot\wss\VirtualDirectories\80\_app_bin\WinLive.SkyShared.Infrastructure.ServiceException.dll
0000000000000000                        0.0 NA                        No   CLR {dynamic-assembly}
0000026e7d130000                        0.0                           Yes  CLR C:\Windows\Microsoft.Net\assembly\GAC_MSIL\Microsoft.SharePoint.CilHelper\v4.0_1.0.0.0__71e9bce111e9429c\Microsoft.SharePoint.CilHelper.dll
0000026e7b4f0000              2.28.446.5333 Microsoft                 No   CLR C:\Windows\Microsoft.Net\assembly\GAC_MSIL\Microsoft.Search.Platform.Parallax\v4.0_2.28.0.0__31bf3856ad364e35\Microsoft.Search.Platform.Parallax.dll
0000026e79850000                    1.0.0.0                           No   CLR C:\Windows\Microsoft.Net\assembly\GAC_MSIL\Microsoft.SPExtensions.IspCompMgr\v4.0_1.0.0.0__71e9bce111e9429c\Microsoft.SPExtensions.IspCompMgr.dll
00000269826c0000                    0.0.0.0                           No   CLR t4n43wvo, Version=0.0.0.0, Culture=neutral, PublicKeyToken=null

27 module(s) listed, 1339 skipped by the filters
```

The last .NET Assembly from this output looks interesting, which is **`CLR t4n43wvo, Version=0.0.0.0, Culture=neutral, PublicKeyToken=null`**. The output from **`dc 00000269826c0000`** (Memory address of t4n43wvo) shows the hexadecimal dump of memory at the specified address, beginning with "MZ" (indicating a Windows executable format).

```
0:000> dc 00000269826c0000
00000269`826c0000  00905a4d 00000003 00000004 0000ffff  MZ..............
00000269`826c0010  000000b8 00000000 00000040 00000000  ........@.......
00000269`826c0020  00000000 00000000 00000000 00000000  ................
00000269`826c0030  00000000 00000000 00000000 00000080  ................
00000269`826c0040  0eba1f0e cd09b400 4c01b821 685421cd  ........!..L.!Th
00000269`826c0050  70207369 72676f72 63206d61 6f6e6e61  is program canno
00000269`826c0060  65622074 6e757220 206e6920 20534f44  t be run in DOS 
00000269`826c0070  65646f6d 0a0d0d2e 00000024 00000000  mode....$.......
```

The output of the **`!dh`** command reveals the headers of the file, confirming that it is a DLL (Dynamic Link Library).

```
0:000> !dh 00000269826c0000

File Type: DLL
FILE HEADER VALUES
     14C machine (i386)
       3 number of sections
6581DD22 time date stamp Tue Dec 19 10:12:50 2023

       0 file pointer to symbol table
       0 number of symbols
      E0 size of optional header
    2102 characteristics
            Executable
            32 bit word machine
            DLL

OPTIONAL HEADER VALUES
     10B magic #
   11.00 linker version
     400 size of code
     600 size of initialized data
       0 size of uninitialized data
    23DE address of entry point
    2000 base of code
         ----- new -----
0000000010000000 image base
    2000 section alignment
     200 file alignment
       3 subsystem (Windows CUI)
    4.00 operating system version
    0.00 image version
    4.00 subsystem version
    8000 size of image
     200 size of headers
       0 checksum
0000000000100000 size of stack reserve
0000000000001000 size of stack commit
0000000000100000 size of heap reserve
0000000000001000 size of heap commit
    8540  DLL characteristics
            Dynamic base
            NX compatible
            No structured exception handler
            Terminal server aware
       0 [       0] address [size] of Export Directory
    2384 [      57] address [size] of Import Directory
    4000 [     2A8] address [size] of Resource Directory
       0 [       0] address [size] of Exception Directory
       0 [       0] address [size] of Security Directory
    6000 [       C] address [size] of Base Relocation Directory
       0 [       0] address [size] of Debug Directory
       0 [       0] address [size] of Description Directory
       0 [       0] address [size] of Special Directory
       0 [       0] address [size] of Thread Storage Directory
       0 [       0] address [size] of Load Configuration Directory
       0 [       0] address [size] of Bound Import Directory
    2000 [       8] address [size] of Import Address Table Directory
       0 [       0] address [size] of Delay Import Directory
    2008 [      48] address [size] of COR20 Header Directory
       0 [       0] address [size] of Reserved Directory


SECTION HEADER #1
   .text name
     3E4 virtual size
    2000 virtual address
     400 size of raw data
     200 file pointer to raw data
       0 file pointer to relocation table
       0 file pointer to line numbers
       0 number of relocations
       0 number of line numbers
60000020 flags
         Code
         (no align specified)
         Execute Read

SECTION HEADER #2
   .rsrc name
     2A8 virtual size
    4000 virtual address
     400 size of raw data
     600 file pointer to raw data
       0 file pointer to relocation table
       0 file pointer to line numbers
       0 number of relocations
       0 number of line numbers
40000040 flags
         Initialized Data
         (no align specified)
         Read Only

SECTION HEADER #3
  .reloc name
       C virtual size
    6000 virtual address
     200 size of raw data
     A00 file pointer to raw data
       0 file pointer to relocation table
       0 file pointer to line numbers
       0 number of relocations
       0 number of line numbers
42000040 flags
         Initialized Data
         Discardable
         (no align specified)
         Read Only
```

This command is used to find and save a specific .NET Assembly from memory to disk:

```
0:000> !netext.wmodule -name t4n43wvo* -saveto C:\Temp
** File 'C:\Temp\t4n43wvo, Version=0.0.0.0, Culture=neutral, PublicKeyToken=null' with same content already exists. Skipping this file
```

![image](https://github.com/DebugPrivilege/InsightEngineering/assets/63166600/9fcb5bfb-0521-414c-817d-6f9277a0a6fa)

We can now load the .NET Assembly in **dnSpy** and here we have extracted our payload from memory:

![image](https://github.com/DebugPrivilege/InsightEngineering/assets/63166600/9835a016-f80a-4595-86e8-e18d0e6e0c82)


The command **`!netext.wruntime`** displays runtime settings for an IIS application pool. It shows details such as the first request time, running time, application pool user, trust level, application domain identifier, debugging status, number of active requests, and file paths for the web application's root, temporary files, and compilation.

```
0:000> !netext.wruntime
Runtime Settings per Application Pool

=========================================================================
Address         : 0000026D6DE564E0
First Request   : 12/19/2023 6:12:05 PM
Runing Time     : 00:02:32
App Pool User   : DC\Administrator
Trust Level     : Full
App Domnain Id  : /LM/W3SVC/292997548/ROOT-1-133474831174272020
Debug Enabled   : False
Active Requests : 0n0
Path            : C:\inetpub\wwwroot\wss\VirtualDirectories\80\ (local disk)
Temp Folder     : C:\Windows\Microsoft.NET\Framework64\v4.0.30319\Temporary ASP.NET Files
Compiling Folder: C:\Windows\Microsoft.NET\Framework64\v4.0.30319\Temporary ASP.NET Files\root\204afe7a\d38d8771
Shutdown Reason : Not shutting down
```

The "Compiling Folder" refers to the directory on the server where ASP.NET dynamically compiled files are stored. When an ASP.NET application runs, the server compiles the application's code and stores the compiled binaries in this folder. These compiled files include the compiled versions of aspx pages, ascx controls, and other resources that require compilation. 

From here, we can run the **`!sosex.strings`** command to search the .NET managed heap for that specifically folder. This could be useful to ientify potential Webshells for example.

```
0:000> !sosex.strings /m:"*C:\Windows\Microsoft.NET\Framework64\v4.0.30319\Temporary ASP.NET Files\root\204afe7a\d38d8771*"
Address            Gen  Value
---------------------------------------
00000269eddf24a8            2   C:\Windows\Microsoft.NET\Framework64\v4.0.30319\Temporary ASP.NET Files\root\204afe7a\d38d8771\hash\hash.web
00000269ede13a48            2   C:\Windows\Microsoft.NET\Framework64\v4.0.30319\Temporary ASP.NET Files\root\204afe7a\d38d8771\ResX
00000269ede17358            2   C:\Windows\Microsoft.NET\Framework64\v4.0.30319\Temporary ASP.NET Files\root\204afe7a\d38d8771\hash
0000026d6e9adb18            0   C:\Windows\Microsoft.NET\Framework64\v4.0.30319\Temporary ASP.NET Files\root\204afe7a\d38d8771\ghostshell5918.aspx.8fcc333
0000026d6e9adc28            0   C:\Windows\Microsoft.NET\Framework64\v4.0.30319\Temporary ASP.NET Files\root\204afe7a\d38d8771\ghostshell5918.aspx.8fcc333.compiled
0000026d6e9add78            0   C:\Windows\Microsoft.NET\Framework64\v4.0.30319\Temporary ASP.NET Files\root\204afe7a\d38d8771\ghostshell5918.aspx.8fcc333.compiled
---------------------------------------
6 matching strings
```

# References

Please review the following references to learn more about this CVE as well as how to secure SharePoint On-Premises:

- **[P2O Vancouver 2023] SharePoint Pre-Auth RCE chain (CVE-2023–29357 & CVE-2023–24955):** https://starlabs.sg/blog/2023/09-sharepoint-pre-auth-rce-chain/
- **SharePoint Patching Best Practices:** https://blog.stefan-gossner.com/2020/02/11/sharepoint-patching-best-practices/
